/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HscEmptyPrintStream;
import com.ibm.hsc.common.util.HscThreadPrintStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class HscPrintStream
extends PrintStream {
    private static final String DEF_STD_OUT_FILE_NAME = "/var/hsc/log/cimserver.log";
    private PrintStream mEmptyPS;
    private PrintStream mCurPS = null;
    private String mFileName = null;
    private static HscPrintStream mInst = null;

    public static HscPrintStream createInstance(boolean bl, String string) {
        HscPrintStream hscPrintStream = HscPrintStream.getInstance();
        if (hscPrintStream == null) {
            mInst = hscPrintStream = new HscPrintStream(bl, string);
            return hscPrintStream;
        }
        return null;
    }

    public static HscPrintStream getInstance() {
        return mInst;
    }

    public HscPrintStream(boolean bl, String string) {
        super(System.out);
        this.mFileName = string;
        if (this.mFileName == null) {
            this.mFileName = DEF_STD_OUT_FILE_NAME;
        }
        this.mEmptyPS = new HscEmptyPrintStream();
        if (bl) {
            this.setTraceOn(this.mFileName);
        } else {
            this.setTraceOff();
        }
    }

    public void setTraceOn(String string) {
        try {
            if (string == null) {
                string = this.mFileName;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            this.mCurPS = new HscThreadPrintStream(fileOutputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setTraceOff() {
        try {
            if (this.mCurPS != null) {
                this.mCurPS.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.mCurPS = this.mEmptyPS;
    }

    public void flush() {
        this.mCurPS.flush();
    }

    public boolean checkError() {
        return this.mCurPS.checkError();
    }

    public void close() {
        this.mCurPS.close();
    }

    public void println() {
        this.mCurPS.println();
    }

    public void println(String string) {
        this.mCurPS.println(string);
    }

    public void println(Object object) {
        this.mCurPS.println(object);
    }

    public void println(boolean bl) {
        this.mCurPS.println(bl);
    }

    public void println(int n) {
        this.mCurPS.println(n);
    }

    public void println(long l) {
        this.mCurPS.println(l);
    }

    public void println(float f) {
        this.mCurPS.println(f);
    }

    public void println(double d) {
        this.mCurPS.println(d);
    }

    public void println(char c) {
        this.mCurPS.println(c);
    }

    public void println(char[] cArray) {
        this.mCurPS.println(cArray);
    }

    public void print(String string) {
        this.mCurPS.print(string);
    }

    public void print(Object object) {
        this.mCurPS.print(object);
    }

    public void print(boolean bl) {
        this.mCurPS.print(bl);
    }

    public void print(int n) {
        this.mCurPS.print(n);
    }

    public void print(long l) {
        this.mCurPS.print(l);
    }

    public void print(float f) {
        this.mCurPS.print(f);
    }

    public void print(double d) {
        this.mCurPS.print(d);
    }

    public void print(char c) {
        this.mCurPS.print(c);
    }

    public void print(char[] cArray) {
        this.mCurPS.print(cArray);
    }

    public void write(int n) {
        this.mCurPS.write(n);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.mCurPS.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.mCurPS.write(byArray);
    }

    public static void main(String[] stringArray) {
        HscPrintStream hscPrintStream = HscPrintStream.createInstance(true, null);
        System.setOut(hscPrintStream);
        System.setErr(hscPrintStream);
        System.out.println("This is a test!");
    }
}

